/*
*  Object %name    : %
*  State           :  %state%
*  Creation date   :  Mar 29 2007
*  Last modified   :  %modify_time%
*/
/** @file
*  \brief A brief description of this module
*
*  \version CE2_TST_KDF.h#1:incl:1
*  \author Yermalayeu Ihar
*  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
*           All Rights reserved
*/

/************* Include Files ****************/

#include <memory.h>
#include "CryptoEngine2.h"
#include "CE2_TST_Common.h"
#include "CE2_TST_KDF.h"

/************************ Defines *******************************/
/************************ Enums *********************************/
/************************ Typedefs ******************************/
/************************ Global Data ***************************/
/*********************** Private Function ***********************/
/************************ Public Functions **********************/

/*****************************************************************************
* Function Name:                                                           
*  CE2_TST_KDF_Concat			
* 
* Inputs:
*  @param[in/out] out - output stream for logs;
*
* Outputs:
*  @return - On success returns CE2_TST_VALID; else returns CE2_TST_FAILED.
*
* Description:																	
* 	Verify functionality of _DX_KDF_KeyDerivFunc function in concatenation mode;
*
* Algorithm:		
*  -#  											
*
******************************************************************************/	
/* Disabled for the time being */
/*
DxStatus CE2_TST_KDF_Concat(FILE *out)
{
  DxStatus result = CE2_OK, error;
  DxUint8_t ZZ[] = {
    0x5E, 0x10, 0xB9, 0x67, 0xA9, 0x56, 0x06, 0x85, 0x3E, 0x52, 0x8F, 0x04, 0x26, 0x2A, 0xD1, 0x8A,
    0x47, 0x67, 0xC7, 0x61, 0x16, 0x39, 0x71, 0x39, 0x1E, 0x17, 0xCB, 0x05, 0xA2, 0x16, 0x68, 0xD4,
    0xCE, 0x2B, 0x9F, 0x15, 0x16, 0x17, 0x40, 0x80, 0x42, 0xCE, 0x09, 0x19, 0x58, 0x38, 0x23, 0xFD,
    0x34, 0x6D, 0x17, 0x51, 0xFB, 0xE2, 0x34, 0x1A, 0xF2, 0xEE, 0x04, 0x61, 0xB6, 0x2F, 0x10, 0x0F,
    0xFA, 0xD4, 0xF7, 0x23, 0xF7, 0x0C, 0x18, 0xB3, 0x82, 0x38, 0xED, 0x18, 0x3E, 0x93, 0x98, 0xC8,
    0xCA, 0x51, 0x7E, 0xE0, 0xCB, 0xBE, 0xFF, 0xF9, 0xC5, 0x94, 0x71, 0xFE, 0x27, 0x80, 0x93, 0x92,
    0x40, 0x89, 0x48, 0x0D, 0xBC, 0x5A, 0x38, 0xE9, 0xA1, 0xA9, 0x7D, 0x23, 0x03, 0x81, 0x06, 0x84,
    0x7D, 0x0D, 0x22, 0xEC, 0xF8, 0x5F, 0x49, 0xA8, 0x61, 0x82, 0x11, 0x99, 0xBA, 0xFC, 0xB0, 0xD7,
    0x4E, 0x6A, 0xCF, 0xFD, 0x7D, 0x14, 0x27, 0x65, 0xEB, 0xF4, 0xC7, 0x12, 0x41, 0x4F, 0xE4, 0xB6,
    0xAB, 0x95, 0x7F, 0x4C, 0xB4, 0x66, 0xB4, 0x66, 0x01, 0x28, 0x9B, 0xB8, 0x20, 0x60, 0x42, 0x82,
    0x72, 0x84, 0x2E, 0xE2, 0x8F, 0x11, 0x3C, 0xD1, 0x1F, 0x39, 0x43, 0x1C, 0xBF, 0xFD, 0x82, 0x32,
    0x54, 0xCE, 0x47, 0x2E, 0x21, 0x05, 0xE4, 0x9B, 0x3D, 0x7F, 0x11, 0x3B, 0x82, 0x50, 0x76, 0xE6,
    0x26, 0x45, 0x85, 0x80, 0x7B, 0xC4, 0x64, 0x54, 0x66, 0x5F, 0x27, 0xC5, 0xE4, 0xE1, 0xA4, 0xBD,
    0x03, 0x47, 0x04, 0x86, 0x32, 0x29, 0x81, 0xFD, 0xC8, 0x94, 0xCC, 0xA1, 0xE2, 0x93, 0x09, 0x87,
    0xC9, 0x2C, 0x15, 0xA3, 0x8B, 0xC4, 0x2E, 0xB3, 0x88, 0x10, 0xE8, 0x67, 0xC4, 0x43, 0x2F, 0x07,
    0x25, 0x9E, 0xC0, 0x0C, 0xDB, 0xBB, 0x0F, 0xB9, 0x9E, 0x17, 0x27, 0xC7, 0x06, 0xDA, 0x58, 0xDD
  };
  DxUint8_t otherInfo[] = "HMAC Key";

  CE2_KDF_OtherInfo_t OtherInfo = {
    otherInfo,
    sizeof(otherInfo),
    DX_NULL,
    0,
    DX_NULL,
    0,
    DX_NULL,
    0,
    DX_NULL,
    0
  };

  DxUint8_t ControlKeyingData[] = {
    0x95, 0xD6, 0x41, 0xF4, 0x26, 0x45, 0x88, 0xE4, 0xE2, 0xB6
  };
  DxUint8_t KeyingData[sizeof(ControlKeyingData)];

  PrintTestBeginMsg(out, __FUNCTION__);

  error = CE2_KDF_ConcatKeyDerivFunc(ZZ, sizeof(ZZ), &OtherInfo, 0,
    CE2_KDF_HASH_SHA1_mode, KeyingData, sizeof(ControlKeyingData));
  if (error != CE2_OK) {
    fprintf(out, "Can't make CE2_KDF_ConcatKeyDerivFunc!");
    result |= error;
    goto test_end;
  }

  if (memcmp(KeyingData, ControlKeyingData, sizeof(ControlKeyingData)) != 0) {
    fprintf(out, "Wrong CE2_KDF_ConcatKeyDerivFunc output!\n");
    PrintBuffer(stdout, KeyingData, sizeof(KeyingData), "\nOutput:");
    PrintBuffer(stdout, ControlKeyingData, sizeof(ControlKeyingData), "\nControl:");
    result |= CE2_TST_FAILED;
    goto test_end;
  }

  PrintTestBeginMsg(out, __FUNCTION__);

test_end:
  PrintTestEndMsg(out, __FUNCTION__, result);

  return result;
}
*/

/*****************************************************************************
* Function Name:                                                           
*  CE2_TST_KDF_ASN1			
* 
* Inputs:
*  @param[in/out] out - output stream for logs;
*
* Outputs:
*  @return - On success returns CE2_TST_VALID; else returns CE2_TST_FAILED.
*
* Description:																	
* 	Verify functionality of _DX_KDF_KeyDerivFunc function in ASN1 mode;
*
* Algorithm:		
*  -#  											
*
******************************************************************************/	
DxStatus CE2_TST_KDF_ASN1(FILE *out)
{
  DxStatus result = CE2_OK, error;

  DxUint8_t ZZ[] = {
    0x5E, 0x10, 0xB9, 0x67, 0xA9, 0x56, 0x06, 0x85, 0x3E, 0x52, 0x8F, 0x04, 0x26, 0x2A, 0xD1, 0x8A,
    0x47, 0x67, 0xC7, 0x61, 0x16, 0x39, 0x71, 0x39, 0x1E, 0x17, 0xCB, 0x05, 0xA2, 0x16, 0x68, 0xD4,
    0xCE, 0x2B, 0x9F, 0x15, 0x16, 0x17, 0x40, 0x80, 0x42, 0xCE, 0x09, 0x19, 0x58, 0x38, 0x23, 0xFD,
    0x34, 0x6D, 0x17, 0x51, 0xFB, 0xE2, 0x34, 0x1A, 0xF2, 0xEE, 0x04, 0x61, 0xB6, 0x2F, 0x10, 0x0F,
    0xFA, 0xD4, 0xF7, 0x23, 0xF7, 0x0C, 0x18, 0xB3, 0x82, 0x38, 0xED, 0x18, 0x3E, 0x93, 0x98, 0xC8,
    0xCA, 0x51, 0x7E, 0xE0, 0xCB, 0xBE, 0xFF, 0xF9, 0xC5, 0x94, 0x71, 0xFE, 0x27, 0x80, 0x93, 0x92,
    0x40, 0x89, 0x48, 0x0D, 0xBC, 0x5A, 0x38, 0xE9, 0xA1, 0xA9, 0x7D, 0x23, 0x03, 0x81, 0x06, 0x84,
    0x7D, 0x0D, 0x22, 0xEC, 0xF8, 0x5F, 0x49, 0xA8, 0x61, 0x82, 0x11, 0x99, 0xBA, 0xFC, 0xB0, 0xD7,
    0x4E, 0x6A, 0xCF, 0xFD, 0x7D, 0x14, 0x27, 0x65, 0xEB, 0xF4, 0xC7, 0x12, 0x41, 0x4F, 0xE4, 0xB6,
    0xAB, 0x95, 0x7F, 0x4C, 0xB4, 0x66, 0xB4, 0x66, 0x01, 0x28, 0x9B, 0xB8, 0x20, 0x60, 0x42, 0x82,
    0x72, 0x84, 0x2E, 0xE2, 0x8F, 0x11, 0x3C, 0xD1, 0x1F, 0x39, 0x43, 0x1C, 0xBF, 0xFD, 0x82, 0x32,
    0x54, 0xCE, 0x47, 0x2E, 0x21, 0x05, 0xE4, 0x9B, 0x3D, 0x7F, 0x11, 0x3B, 0x82, 0x50, 0x76, 0xE6,
    0x26, 0x45, 0x85, 0x80, 0x7B, 0xC4, 0x64, 0x54, 0x66, 0x5F, 0x27, 0xC5, 0xE4, 0xE1, 0xA4, 0xBD,
    0x03, 0x47, 0x04, 0x86, 0x32, 0x29, 0x81, 0xFD, 0xC8, 0x94, 0xCC, 0xA1, 0xE2, 0x93, 0x09, 0x87,
    0xC9, 0x2C, 0x15, 0xA3, 0x8B, 0xC4, 0x2E, 0xB3, 0x88, 0x10, 0xE8, 0x67, 0xC4, 0x43, 0x2F, 0x07,
    0x25, 0x9E, 0xC0, 0x0C, 0xDB, 0xBB, 0x0F, 0xB9, 0x9E, 0x17, 0x27, 0xC7, 0x06, 0xDA, 0x58, 0xDD
  };
  DxUint8_t AlgorithmID[] = {
    0x30, 0x09, 0x06, 0x07, 0x2A, 0x86, 0x48, 0xCE, 0x3F, 0x01, 0x02
  }; 

  DxUint8_t SuppPrivInfo[] = {
    0x4A, 0x6F, 0x68, 0x6E, 0x20, 0x4B, 0x65, 0x6E, 0x6E, 0x65, 0x64, 0x79,
    0x20, 0x61, 0x6E, 0x64, 0x20, 0x46, 0x72, 0x69, 0x65, 0x6E, 0x64, 0x73
  };
  CE2_KDF_OtherInfo_t OtherInfo = {
    AlgorithmID,
    sizeof(AlgorithmID),
    DX_NULL,
    0,
    DX_NULL,
    0,
    SuppPrivInfo,
    sizeof(SuppPrivInfo),
    DX_NULL,
    0
  };
  DxUint8_t ControlKeyingData[] = {
    0x31, 0xB0, 0xCA, 0x24, 0xDF, 0x4A, 0xFD, 0xE9,
    0xB6, 0xD6, 0x44, 0xE9, 0xDC, 0x3B, 0x03, 0x0E,
    0x42, 0x9D, 0x7E, 0x15, 0x2D, 0x90, 0x9C, 0x8F
  };
  DxUint8_t KeyingData[sizeof(ControlKeyingData)];

  PrintTestBeginMsg(out, __FUNCTION__);

  error = CE2_KDF_ASN1_KeyDerivFunc(ZZ, sizeof(ZZ), &OtherInfo,
    CE2_KDF_HASH_SHA1_mode, KeyingData, sizeof(ControlKeyingData));
  if (error != CE2_OK) {
    fprintf(out, "Can't make CE2_KDF_ASN1_KeyDerivFunc!");
    result |= error;
    goto test_end;
  }

  if (memcmp(KeyingData, ControlKeyingData, sizeof(ControlKeyingData)) != 0) {
    fprintf(out, "Wrong CE2_KDF_ASN1_KeyDerivFunc output!\n");
    PrintBuffer(stdout, KeyingData, sizeof(KeyingData), "\nOutput:");
    PrintBuffer(stdout, ControlKeyingData, sizeof(ControlKeyingData), "\nControl:");
    result |= CE2_TST_FAILED;
    goto test_end;
  }


test_end:
  PrintTestEndMsg(out, __FUNCTION__, result);

  return result;
}
